/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

public class FtpDirEntry {
    private final String name;
    private String user = null;
    private String group = null;
    private long size = -1L;
    private Date created = null;
    private Date lastModified = null;
    private Type type = Type.FILE;
    private boolean[][] permissions = null;
    private HashMap<String, String> facts = new HashMap();

    private FtpDirEntry() {
        this.name = null;
    }

    public FtpDirEntry(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public FtpDirEntry setUser(String string) {
        this.user = string;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public FtpDirEntry setGroup(String string) {
        this.group = string;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public FtpDirEntry setSize(long l) {
        this.size = l;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public FtpDirEntry setType(Type type) {
        this.type = type;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public FtpDirEntry setLastModified(Date date) {
        this.lastModified = date;
        return this;
    }

    public boolean canRead(Permission permission) {
        if (this.permissions != null) {
            return this.permissions[permission.value][0];
        }
        return false;
    }

    public boolean canWrite(Permission permission) {
        if (this.permissions != null) {
            return this.permissions[permission.value][1];
        }
        return false;
    }

    public boolean canExexcute(Permission permission) {
        if (this.permissions != null) {
            return this.permissions[permission.value][2];
        }
        return false;
    }

    public FtpDirEntry setPermissions(boolean[][] blArray) {
        this.permissions = blArray;
        return this;
    }

    public FtpDirEntry addFact(String string, String string2) {
        this.facts.put(string.toLowerCase(), string2);
        return this;
    }

    public String getFact(String string) {
        return this.facts.get(string.toLowerCase());
    }

    public Date getCreated() {
        return this.created;
    }

    public FtpDirEntry setCreated(Date date) {
        this.created = date;
        return this;
    }

    public String toString() {
        if (this.lastModified == null) {
            return this.name + " [" + (Object)((Object)this.type) + "] (" + this.user + " / " + this.group + ") " + this.size;
        }
        return this.name + " [" + (Object)((Object)this.type) + "] (" + this.user + " / " + this.group + ") {" + this.size + "} " + DateFormat.getDateInstance().format(this.lastModified);
    }

    public static enum Permission {
        USER(0),
        GROUP(1),
        OTHERS(2);

        int value;

        private Permission(int n2) {
            this.value = n2;
        }
    }

    public static enum Type {
        FILE,
        DIR,
        PDIR,
        CDIR,
        LINK;

    }
}

