/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.event;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.util.logging.PlatformLogger;

public final class EventHelper {
    private static final PlatformLogger.Level LOG_LEVEL = PlatformLogger.Level.FINE;
    private static final String SECURITY_LOGGER_NAME = "jdk.event.security";
    private static final PlatformLogger SECURITY_LOGGER = PlatformLogger.getLogger("jdk.event.security");
    private static final boolean LOGGING_SECURITY = SECURITY_LOGGER.isLoggable(LOG_LEVEL);

    public static void logTLSHandshakeEvent(Instant instant, String string, int n, String string2, String string3, long l) {
        String string4 = EventHelper.getDurationString(instant);
        SECURITY_LOGGER.fine(string4 + " TLSHandshake: {0}:{1}, {2}, {3}, {4}", string, n, string3, string2, l);
    }

    public static void logSecurityPropertyEvent(String string, String string2) {
        SECURITY_LOGGER.fine("SecurityPropertyModification: key:{0}, value:{1}", string, string2);
    }

    public static void logX509ValidationEvent(int n, int[] nArray) {
        String string = IntStream.of(nArray).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        SECURITY_LOGGER.fine("ValidationChain: {0}, {1}", n, string);
    }

    public static void logX509CertificateEvent(String string, String string2, String string3, String string4, String string5, int n, long l, long l2, long l3) {
        SECURITY_LOGGER.fine("X509Certificate: Alg:{0}, Serial:{1}, Subject:{2}, Issuer:{3}, Key type:{4}, Length:{5}, Cert Id:{6}, Valid from:{7}, Valid until:{8}", string, string2, string3, string4, string5, n, l, new Date(l2), new Date(l3));
    }

    private static String getDurationString(Instant instant) {
        if (instant != null) {
            Duration duration = Duration.between(instant, Instant.now());
            long l = duration.toNanos() / 1000L;
            if (l < 1000000L) {
                return "duration = " + (double)l / 1000.0 + " ms:";
            }
            return "duration = " + (double)(l / 1000L) / 1000.0 + " s:";
        }
        return "";
    }

    public static boolean isLoggingSecurity() {
        return LOGGING_SECURITY;
    }
}

